<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DfElqui;
use App\Models\Canal;

class UpdateCanalIdInDfElqui extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:canal_id';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update canal_id in df_elqui table based on Canal name';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $records = DfElqui::all();
        foreach ($records as $record) {
            $canal = Canal::where('nombre', $record->Canal)->first();
            if ($canal) {
                $record->canal_id = $canal->id;
                $record->save();
                $this->info("Updated record ID {$record->id} with canal_id {$canal->id}");
            } else {
                $this->warn("Canal with name '{$record->Canal}' not found for record ID {$record->id}");
            }
        }

        $this->info('Canal IDs updated successfully.');
        return 0;
    }
}
