<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    public function login(Request $request)
{
    $credentials = $request->validate([
        'email' => ['required', 'email'],
        'password' => ['required']
    ]);

    // Verificar si el usuario existe
    $user = User::where('email', $credentials['email'])->first();

    if (!$user) {
        return response()->json(['message' => 'Credenciales incorrectas.'], 401);
    }

    // Verificar si el correo ha sido confirmado
    if (!$user->hasVerifiedEmail()) {
        return response()->json(['message' => 'Por favor verifica tu correo antes de iniciar sesión.'], 403);
    }

    if (!$token = JWTAuth::attempt($credentials)) {
        return response()->json(['message' => 'Credenciales incorrectas.'], 401);
    }

    return response()->json([
        'access_token' => $token,
        'token_type' => 'Bearer',
    ], 200);
}


    public function logout(Request $request)
    {
        Auth::logout();
        return response()->json(['message' => 'Successfully logged out']);
    }
}
