<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Componente1Prommra;
use App\Models\Componente2Prommra;
use App\Models\Componente3Prommra;
use Illuminate\Support\Facades\Log; // Importa el Log facade

class CanalController extends Controller
{
    /**
     * Obtener datos de las tres tablas para un canal específico y un período específico.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $canalId
     * @return \Illuminate\Http\JsonResponse
     */
    public function obtenerDatosCanal(Request $request, $canalId)
    {
        // Obtener el parámetro 'periodo' de la solicitud, si está presente
        $periodo = $request->input('periodo');

        // Obtener el valor de `Clasificacion_CV` en Componente 1 usando la probabilidad de excedencia más cercana a 85
        $componente1 = Componente1Prommra::where('canal_id', $canalId)
            ->when($periodo, function ($query, $periodo) {
                return $query->where('Periodo', 'LIKE', "%$periodo%");
            })
            ->orderByRaw("ABS(Probabilidad_excedencia - 85)")
            ->first(); // Solo obtenemos el registro más cercano a 85

        $componente1Clasificacion = $componente1 ? $componente1->Clasificacion_CV : null;

        // Obtener el valor de `Clasificacion_CV` en Componente 2 para el periodo
        $componente2 = Componente2Prommra::where('canal_id', $canalId)
            ->when($periodo, function ($query, $periodo) {
                return $query->where('Periodo', 'LIKE', "%$periodo%");
            })
            ->first(); // Se obtiene el primer registro del periodo

        $componente2Clasificacion = $componente2 ? $componente2->Clasificacion_CV : null;

        // Obtener el valor de `clasificación` en Componente 3 usando la probabilidad de excedencia más cercana a 85
        $componente3 = Componente3Prommra::where('canal_id', $canalId)
            ->when($periodo, function ($query, $periodo) {
                return $query->where('Periodo', 'LIKE', "%$periodo%");
            })
            ->orderByRaw("ABS(probabilidad_excedencia - 85)")
            ->first(); // Solo obtenemos el registro más cercano a 85

        $componente3Clasificacion = $componente3 ? $componente3->clasificación : null;


        if (is_null($componente1Clasificacion)) {
            Log::warning("No se encontró clasificación en Componente 1 para el canal {$canalId} y periodo {$periodo}");
        }
        if (is_null($componente2Clasificacion)) {
            Log::warning("No se encontró clasificación en Componente 2 para el canal {$canalId} y periodo {$periodo}");
        }
        if (is_null($componente3Clasificacion)) {
            Log::warning("No se encontró clasificación en Componente 3 para el canal {$canalId} y periodo {$periodo}");
        }

        // Estructurar la respuesta JSON con las clasificaciones obtenidas
        $response = [
            'canal_id' => $canalId,
            'componente_1_clasificacion' => $componente1Clasificacion,
            'componente_2_clasificacion' => $componente2Clasificacion,
            'componente_3_clasificacion' => $componente3Clasificacion,
        ];

        return response()->json($response);
    }
}
