<?php

namespace App\Http\Controllers;

use App\Models\Emaceaza;
use App\Models\Etodiaria;
use App\Models\Etofactor;
use App\Models\Etomensual;
use App\Models\PrecipitacionDiaria;
use App\Models\Precipitacionmensual;
use App\Models\Sectorhidrico;
use App\Models\Canal;
use App\Models\Comuna;
use App\Models\Provincia;
use App\Models\Organizacion;
use App\Models\Seccionrio;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;


class CeazametController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Función se encarga de ir a buscar evatranspiración y precipitaciones diarias al ceazamet
     */
    public function estacion()
{
    /**DB::insert('insert into cron (date, cron) values (?, ?)', [date('Y-m-d H:i:s'), 'Eto diaria Ceaza Task']);*/
    $fechaini = '2024-04-01';
    $fechafin = '2024-06-26';

    // Lista de sectores que no se incluyeron en la consulta API
    $sectores_faltantes = [
        "Salamanca",
    ];

    foreach ($sectores_faltantes as $sector) {
        // Obtener la estación correspondiente al sector
        $emaceaza = Emaceaza::where('nombre', $sector)->first();

        if ($emaceaza) {
            // Consultar evapotranspiración diaria
            $url = "https://www.ceazamet.cl/ws/pop_ws.php?fn=GetSerieSensor&p_cod=ceazamet&s_cod=".$emaceaza->sensorevo."&fecha_inicio=$fechaini&fecha_fin=$fechafin&tipo_resp=json&interv=dia";
            $registrosDiarios = file_get_contents($url);
            $data = json_decode($registrosDiarios);
            if (isset($data->serie)) {
                foreach ($data->serie as $serie) {
                    $eto_value = !is_null($serie->prom) ? $serie->prom : null;
                    $date = Carbon::parse($serie->fecha)->format('Y-m-d');
                    if (Etodiaria::where('date', $date)->where('emaceaza_id', $emaceaza->id)->count() == 0) {
                        $eto = new Etodiaria();
                        $eto->eto = $eto_value;
                        $eto->date = $date;
                        $eto->emaceaza_id = $emaceaza->id;
                        $eto->save();
                    }
                }
            }

            // Consultar precipitaciones diarias
            $url = "https://www.ceazamet.cl/ws/pop_ws.php?fn=GetSerieSensor&p_cod=ceazamet&s_cod=".$emaceaza->sensorprecipitacion."&fecha_inicio=$fechaini&fecha_fin=$fechafin&tipo_resp=json&interv=dia";
            $registrosDiarios = file_get_contents($url);
            $data = json_decode($registrosDiarios);
            if (isset($data->serie)) {
                foreach ($data->serie as $serie) {
                    $pp_value = !is_null($serie->prom) ? $serie->prom : null;
                    $date = Carbon::parse($serie->fecha)->format('Y-m-d');
                    $existe = PrecipitacionDiaria::where('date', $date)->where('emaceaza_id', $emaceaza->id)->first();
                    if (!empty($existe)) {
                        $existe->pp = $pp_value;
                        $existe->save();
                    } else {
                        $pp = new PrecipitacionDiaria();
                        $pp->pp = $pp_value;
                        $pp->date = $date;
                        $pp->emaceaza_id = $emaceaza->id;
                        $pp->save();
                    }
                }
            }
        }
    }

    return redirect('/home');
}

    /**
     * Función que trae las estaciones
     */

    public function getEstaciones()
    {
        $estaciones = Emaceaza::all(['id', 'nombre', 'codeceaza']);
        return response()->json($estaciones);
    }

    /**
     * Función sensor:  se encarga de ir a buscar el código del sensor de la estación y lo guarda.
     * Esta función servirá en el caso que quieran registrar más estaciones.
     */
    public function sensor(){
        //$d = file_get_contents("https://www.ceazamet.cl/ws/pop_ws.php?fn=GetSerieSensor&p_cod=ceazamet&s_cod=LAGELAN&fecha_inicio=$inicio&fecha_fin=$fin&valor_nan=&formato_nro=6.3&tipo_resp=json&interv=dia");
        $estaciones = Emaceaza::get();
        foreach($estaciones as $estacion){
            $sensor = $this->traeSensor($estacion->codeceaza,'Precipitación');
            $estacion->sensorprecipitacion = $sensor;
            $estacion->save();
        }
    }

    /**
     * Función traeSensor:  retorna el código para un nombre de sensor específico
     */
    public function traeSensor($codeceaza,$nombre){
        $d = file_get_contents("https://www.ceazamet.cl/ws/pop_ws.php?fn=GetListaSensores&p_cod=ceazamet&e_cod=".$codeceaza."&user=anon@host.com&tipo_resp=json");
        $data = json_decode($d);
        foreach($data as $d){
            if($d->tf_nombre == $nombre){
                return $d->s_cod;
            }
        }
        return null;
    }

    /**
     * Vista eto diaria
     */
    public function diario(Request $request)
    {
        $estacion_id = $request->input('emaceaza_id', Emaceaza::first()->id);
        $eto = Etodiaria::where('emaceaza_id', $estacion_id)->orderBy('date', 'desc')->get();
        return response()->json($eto);
    }



    /**
     * vista eto mensual
     */
    public function mensual(){
        if(isset($_GET['sectorhidrico_id'])){
            $sectorhidrico_id = $_GET['sectorhidrico_id'];
        }else{
            $sectorhidrico_id = Sectorhidrico::first()->id;
        }
        $eto = Etomensual::where('sectorhidrico_id',$sectorhidrico_id)->orderBy('anho','desc')->orderBy('mes','desc')->get();

        $sectoreshidricos = Sectorhidrico::orderBy('nombre','asc')->pluck('nombre','id');

        $sectorhidrico = Sectorhidrico::findOrFail($sectorhidrico_id);

        return View('ceaza.mensual',compact('eto','sectoreshidricos','sectorhidrico'));
    }

    /**
     * vista precipitación diaria
     */
    public function ppdiario(Request $request)
    {
        $estacion_id = $request->input('emaceaza_id', Emaceaza::first()->id);
        $pps = PrecipitacionDiaria::where('emaceaza_id', $estacion_id)->orderBy('date', 'desc')->get();
        return response()->json($pps);
    }

     /**
     * vista precipitación mensual
     */
    public function ppmensual(Request $request)
{
    $selectedSectorId = $request->input('sectorhidrico_id');

    // Recuperar todos los sectores hídricos disponibles.
    $sectoreshidricos = Sectorhidrico::orderBy('nombre', 'asc')->pluck('nombre', 'id');

    $sectorData = [];

    if ($selectedSectorId) {
        // Recuperar todos los registros de precipitación mensual para el sector seleccionado.
        $sectorData = Precipitacionmensual::where('sectorhidrico_id', $selectedSectorId)
            ->orderBy('anho', 'desc')
            ->orderBy('mes', 'desc')
            ->get();
    }

    return view('ceaza.ppmensual', compact('sectoreshidricos', 'sectorData', 'selectedSectorId'));
}

    /**
     * vista consulta
     */
    public function consultaCanal(Request $request)
    {
        // Recuperar datos de provincias y organizaciones
        $provincias = Provincia::orderBy('nombre', 'asc')->get();
        $organizaciones = Organizacion::orderBy('nombre', 'asc')->get();

        // Lógica para recuperar otros datos necesarios, como secciones de río, etc.

        // Devolver los datos como respuesta JSON
        return response()->json([
            'provincias' => $provincias,
            'organizaciones' => $organizaciones,
            // Incluir otros datos necesarios en el arreglo
        ]);
    }

// Método para obtener las comunas de una provincia específica
public function obtenerComunas($provincia_id)
{
    $comunas = Comuna::where('provincia_id', $provincia_id)->orderBy('nombre', 'asc')->pluck('nombre', 'id');
    return response()->json($comunas);
}

public function obtenerCanales($provincia_id, $comuna_id)
{
    try {
        $canales = Canal::where('comuna_id', $comuna_id)
                    ->orderBy('nombre', 'asc')
                    ->pluck('nombre', 'id');
        return response()->json($canales);
    } catch (\Exception $e) {
        Log::error('Error al obtener los canales: ' . $e->getMessage());
        return response()->json(['error' => 'Error interno del servidor'], 500);
    }
}



    /**
     * Función generarmensual:  se encarga de generar la evapotranspiración mensual para cada sector hidrico
     * TODO: esto se debe automatizar para que se ejecute cada mes o cada vez que se registra un valor diario con un data_pc de 100.
     */
    public function generatemensual() {
        $meses = [
            '2024-06' => Carbon::parse('2024-06-01')->endOfMonth(),
            '2024-07' => Carbon::parse('2024-07-02')->endOfMonth()
        ];
        $sector_ids = [
            10101, 10102, 10103, 10104, 10105, 10106, 10107, 10108,
            10201, 10301, 20101, 20102, 20103, 20104, 20105, 20201,
            20202, 20203, 20204, 20205, 20301, 20302, 20303, 20304,
            20305, 20306, 20307, 20308, 20309, 20310, 20311, 20312,
            20313, 20314, 20315, 20316, 20317, 20318, 20319, 20401,
            20402, 20403, 20404, 20501, 20502, 20601, 20602, 20701,
            20801, 20802, 20803, 20804, 20901, 20902, 20903, 20904,
            21001, 21101, 21102, 21201, 21202, 21203, 21301, 22001,
            22002, 22003, 22004, 22101, 30101, 30102, 30103, 30104,
            30201, 30202, 30301, 30302, 30303, 30304, 30305, 30306,
            30307, 30308, 30309, 30310
        ];

        foreach (array_chunk($sector_ids, 5) as $sector_group) {
            $sectoreshidricos = Sectorhidrico::whereIn('id', $sector_group)->get();
            foreach ($sectoreshidricos as $s) {
                foreach ($meses as $start => $end) {
                    $fechaini = Carbon::parse("$start-01");
                    $fechafin = $end;
                    $mensual = 0;
                    $cantidadestaciones = 0;

                    foreach ($s->emaceazas as $estacion) {
                        $factor = Etofactor::where('sectorhidrico_id', $s->id)
                            ->where('emaceaza_id', $estacion->id)
                            ->where('mes', $fechaini->format('n'))
                            ->first();

                        if ($factor) {
                            $mensualestacion = Etodiaria::where('emaceaza_id', $estacion->id)
                                ->whereBetween('date', [$fechaini, $fechafin])
                                ->sum('eto');
                            if (!empty($factor) and $mensualestacion != 0) {
                                $mensualestacion = $mensualestacion * $factor->factor;
                                $mensual = $mensual + $mensualestacion;
                                $cantidadestaciones++;
                            }
                        }
                    }

                    if ($cantidadestaciones > 0) {
                        $mensual = $mensual / $cantidadestaciones;
                    }

                    $etomensualbd = Etomensual::where('sectorhidrico_id', $s->id)
                        ->where('anho', $fechaini->format('Y'))
                        ->where('mes', $fechaini->format('n'))
                        ->first();
                    if (empty($etomensualbd)) {
                        $etomensualbd = new Etomensual();
                        $etomensualbd->eto = $mensual;
                        $etomensualbd->anho = $fechaini->format('Y');
                        $etomensualbd->mes = $fechaini->format('n');
                        $etomensualbd->sectorhidrico_id = $s->id;
                        $etomensualbd->save();
                    } else {
                        $etomensualbd->eto = $mensual;
                        $etomensualbd->save();
                    }
                }
            }
        }

        // Redirigir al home después de completar el procesamiento
        return redirect('/home');
    }



    /*
    /**
     * Función asociarSectores:  se encarga de asociar los sectores hidricos a las estaciones (ya que en la base de datos no se hizo)
     */
    public function asociarSectores(){
        $estaciones = Emaceaza::get();
        foreach($estaciones as $estacion){
            $etofactor = Etofactor::where('emaceaza_id',$estacion->id)->get();
            $sectores = [];
            foreach($etofactor as $e){
                $sectores[$e->sectorhidrico_id] = $e->sectorhidrico_id;
            }
            foreach($sectores as $s){
                DB::insert('insert into sectorhidrico_emaceaza (sectorhidrico_id, emaceaza_id ) values (?, ?)', [$s,$estacion->id]);
            }
        }
    }

/**
 * Obtiene los datos de precipitación mensual por año para poblar la base de datos
 */
public function actualizacionInicial()
{
    // Define el código del sensor de precipitación
    $sensorCode = 'CHILLPP';

    // Construye la URL de consulta para el sensor específico
    $url = "https://www.ceazamet.cl/ws/pop_ws.php?fn=GetSerieSensor&p_cod=ceazamet&s_cod={$sensorCode}&fecha_inicio=2024-06-01&fecha_fin=2024-07-02&interv=mes";

    try {
        $response = Http::get($url);

        if ($response->successful()) {
            $responseData = $response->body();
            $lines = explode("\n", $responseData);
            $lines = array_slice($lines, 5);

            foreach ($lines as $line) {
                $data = str_getcsv($line, ',');

                if (count($data) >= 6) {
                    $sensorCode = $data[0];
                    $ultimaLectura = $data[1];
                    $prom = $data[3];

                    $ppValue = (isset($prom) && $prom !== '') ? $prom : 0;

                    $date = Carbon::parse($ultimaLectura);
                    $year = $date->year;
                    $month = $date->month;

                    $sectores = Sectorhidrico::whereHas('emaceazas', function ($query) use ($sensorCode) {
                        $query->where('sensorprecipitacion', $sensorCode);
                    })->get();

                    foreach ($sectores as $sector) {
                        $sectorId = $sector->id;

                        Log::info("Procesando datos para el sector hídrico $sectorId: Año $year, Mes $month, Promedio $ppValue");

                        Precipitacionmensual::updateOrInsert([
                            'sectorhidrico_id' => $sectorId,
                            'anho' => $year,
                            'mes' => $month,
                        ], [
                            'pp' => $ppValue,
                        ]);

                        Log::info("Registro insertado/actualizado en precipitacionmensuals");
                    }
                } else {
                    Log::warning("La respuesta de la API no contiene datos válidos");
                }
            }
        } else {
            Log::warning("La respuesta de la API no pudo ser obtenida para el sensor CHILLPP");
        }
    } catch (\Exception $e) {
        Log::error("Error al procesar la API de Ceazamet: " . $e->getMessage());
    }

    return redirect()->route('ceaza.ppmensual')->with('success', 'Actualización inicial completada.');
}



}
