<?php

namespace App\Http\Controllers;

use App\Models\DfElquiIpsl;
use App\Models\DfLimari;
use App\Models\DfChoapa;
use Illuminate\Http\Request;

class DfElquiIpslController extends Controller
{
    /**
     *
     *
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        // Obtener parámetros de la solicitud
        $canalId = $request->input('canal_id');
        $periodo = $request->input('periodo');

        // Consultar primero en DfElquiIpsl
        $data = $this->getDataFromModel(DfElquiIpsl::class, $canalId, $periodo);

        // Si no hay resultados, consultar en DfLimari
        if ($data->isEmpty()) {
            $data = $this->getDataFromModel(DfLimari::class, $canalId, $periodo);
        }

        // Si aún no hay resultados, consultar en DfChoapa
        if ($data->isEmpty()) {
            $data = $this->getDataFromModel(DfChoapa::class, $canalId, $periodo);
        }

        // Retornar los resultados como JSON
        return response()->json($data);
    }

    /**
     * Get data from a given model based on canal_id and periodo.
     *
     * @param string $modelClass
     * @param int $canalId
     * @param string|null $periodo
     * @return \Illuminate\Database\Eloquent\Collection
     */
    protected function getDataFromModel($modelClass, $canalId, $periodo = null)
    {
        // Crear la consulta base
        $query = $modelClass::where('canal_id', $canalId);

        // Agregar filtro de periodo si está presente
        if (!empty($periodo)) {
            $query->where('Periodo', $periodo);
        }

        return $query->get();
    }
}
