<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;  // Asegúrate de importar el modelo User si no lo has hecho
use Illuminate\Support\Facades\Hash;  // Asegúrate de importar el facade Hash para la verificación de contraseñas

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function login(Request $request)  // Inyectamos el objeto Request aquí
    {
        // Buscamos el usuario por su email
        $user = User::where('email', $request->email)->first();

        // Verificamos si el usuario existe y si la contraseña es correcta
        if ($user && Hash::check($request->password, $user->password)) {
            dd("OK");
        } else {
            dd("FALSE");
        }
    }
}
