<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Canal;
use App\Models\Kc;
use App\Models\Etomensual;
use App\Models\OfertaCsiro;
use App\Models\Clasificacionpoligono;
use App\Models\Eficiencia;

class HydricBalanceController extends Controller
{
    public function getHydricBalance(Request $request)
    {
        try {
            $year = $request->input('year', 2021);
            $month = $request->input('month', 11);
            $date = $request->input('date', '2021-11-01');

            // Canal info (obtener todos los canales)
            $canales = Canal::select('id', 'nombre', 'comuna_id', 'sectorhidrico_id')
                ->with('seccioncanals')
                ->get();

            $resultados = [];

            foreach ($canales as $canal_info) {
                // Kc info
                $kc_info = Kc::select('kc', 'sectorhidrico_id', 'anho', 'mes')
                    ->where('anho', $year)
                    ->where('mes', $month)
                    ->where('sectorhidrico_id', $canal_info->sectorhidrico_id)
                    ->with('grupo:id,nombre')
                    ->get();

                // ETo info
                $eto_info = Etomensual::select('eto', 'sectorhidrico_id')
                    ->where('anho', $year)
                    ->where('mes', $month)
                    ->where('sectorhidrico_id', $canal_info->sectorhidrico_id)
                    ->first();

                // Oferta info
                $oferta_info = OfertaCsiro::select('ofertahidrica', 'fecha')
                    ->where('canal_id', $canal_info->id)
                    ->whereDate('fecha', $date)
                    ->first();

                // Superficies info
                $superficies_info = Clasificacionpoligono::selectRaw('grupos.nombre as cultivo, SUM(poligonos.superficie) as superficie_total')
                    ->join('grupos', 'clasificacionpoligonos.grupo_id', '=', 'grupos.id')
                    ->join('poligonos', 'clasificacionpoligonos.poligono_id', '=', 'poligonos.id')
                    ->where('clasificacionpoligonos.anho', $year)
                    ->where('poligonos.seccioncanal_id', $canal_info->seccioncanals->first()->id ?? null)
                    ->where('grupos.nombre', '!=', 'Sin Cultivo')
                    ->groupBy('grupos.nombre')
                    ->get();

                // Eficiencias info
                $eficiencias_info = Eficiencia::select('eficiencia')
                    ->where('comuna_id', $canal_info->comuna_id)
                    ->with('grupo:id,nombre')
                    ->get();

                $resultados[] = [
                    'canal_info' => $canal_info,
                    'kc_info' => $kc_info,
                    'eto_info' => $eto_info,
                    'oferta_info' => $oferta_info,
                    'superficies_info' => $superficies_info,
                    'eficiencias_info' => $eficiencias_info,
                ];
            }

            return response()->json($resultados);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
