<?php

namespace App\Http\Controllers;

use App\Models\IndicadorPrommra;
use Illuminate\Http\Request;

class IndicadorPrommraController extends Controller
{
    /**
     * Display a listing of the resource based on canal_id and periodo or Periodo.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $canalId = $request->input('canal_id');
        $periodo = $request->input('periodo');

        // Construir la consulta base
        $query = IndicadorPrommra::where('canal_id', $canalId);

        // Añadir condición para 'periodo' o 'Periodo'
        if (!empty($periodo)) {
            $query->where(function ($subquery) use ($periodo) {
                $subquery->where('periodo', $periodo)
                         ->orWhere('Periodo', $periodo);
            });
        }

        // Ejecutar la consulta
        $data = $query->get();

        // Devolver los datos en formato JSON
        return response()->json($data);
    }
}
