<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Provincia;
use App\Models\Comuna;
use App\Models\Canal;
use App\Models\Seccioncanal;
use App\Models\Cuenca;
use App\Models\Subcuenca;
use App\Models\Organizacion;
use App\Models\Seccionrio;

class LocationController extends Controller
{
    protected $excludedCanalIds = [
        '10101003', '10107013', '10107016', '10107020', '10105015',
        '10107001', '10104018', '10104019', '10106003', '10107003', '10103014',
        '10107005', '10107006', '10105027', '10105030', '10102008', '10105036',
        '20306016', '10105040', '10102011', '20101018', '20319012',
        '20105012', '10107022', '10103002', '10103003', '10103004', '10201005',
        '10101011', '10103012', '10105010', '10105019', '10104004',
        '20501008', '20501004', '20601024', '20601003', '20601021', '20502009',
        '20601025', '20502016', '20502017', '20601001', '20601028', '20601019',
        '20701015', '20601017', '20601014', '20601022', '20601015', '20301003',
        '20205003', '20309005', '20301002', '20301001', '20302002', '20302003',
        '20404010', '20401002', '20201004', '20309010', '20309011', '20302005',
        '20303002', '20302007', '20401007', '20404004', '20401003', '20305007',
        '20304011', '20401001', '20401005', '20309020', '20303004', '20305003',
        '20302010', '20303006', '20303008', '20309023', '20311007', '20307002',
        '20302011', '20309024', '20304009', '20311006', '20301011', '20308004',
        '20304012', '20305008', '20306010', '20304008', '20306012', '20304010',
        '20301010', '20304014', '20304005', '20308005', '20304003', '20304007',
        '20310002', '20304006', '20305009', '20403002', '20304004', '20312001',
        '20312002', '20318002', '20103013', '20102011', '20101004', '20101005',
        '20103020', '20101008', '20104001', '20101007', '30305006',
        '30101027', '20318001', '20319002', '20501001', '30310001', '20601026',
        '30306005', '30302009', '30306006', '30302010', '30302011', '20309001',
        '30310002', '30103015', '30101028', '30202017', '20701016', '30101010',
        '30308018', '30308020', '30101029', '30308022', '30305005', '30301002',
        '30305007', '30103016', '30308019', '30301005', '30307006', '30310003',
        '20309014', '20601027', '30310004', '30202005', '30304011', '30304014',
        '30103012', '20309018', '30310005', '30310006', '30310007', '30101024',
        '30310008', '30310009', '30302016', '30302017', '30308021', '30310010'
    ];

    public function getProvincias()
    {
        $provincias = Provincia::all();
        return response()->json($provincias);
    }

    public function getComunas($provinciaId)
    {
        $excludedComunaIds = ['4103', '4104'];

        $comunas = Comuna::where('provincia_id', $provinciaId)
                        ->whereNotIn('id', $excludedComunaIds)
                        ->get();
        return response()->json($comunas);
    }

    public function getCanales($comunaId)
    {
        $canales = Canal::where('comuna_id', $comunaId)
                        ->whereNotIn('id', $this->excludedCanalIds)
                        ->get();
        return response()->json($canales);
    }

    public function searchCanales(Request $request)
    {
        $query = $request->input('query');
        $canales = Canal::where('nombre', 'LIKE', "%{$query}%")
                        ->whereNotIn('id', $this->excludedCanalIds)
                        ->get();
        return response()->json($canales);
    }

    public function getSeccionCanalById($id)
    {
        $seccioncanal = Seccioncanal::where('canal_id', $id)->first();
        return response()->json($seccioncanal);
    }

    public function searchSeccionCanales(Request $request)
    {
        $query = $request->input('query');
        $seccioncanales = Seccioncanal::where('nombre', 'LIKE', "%{$query}%")->get();
        return response()->json($seccioncanales);
    }

    public function getCuencas()
    {
        $allowedCuencaIds = ['43', '45', '47'];

        $cuencas = Cuenca::whereIn('id', $allowedCuencaIds)
                        ->get();
        return response()->json($cuencas);
    }

    public function getSubcuencas()
    {
        $subcuencas = Subcuenca::all();
        return response()->json($subcuencas);
    }

    // Nuevos métodos
    public function getOrganizaciones()
    {
        $organizaciones = Organizacion::all();
        return response()->json($organizaciones);
    }

    public function getSeccionrios()
    {
        $excludedSeccionrioIds = [
            '101111', '101101', '101091', '101081', '101071', '101061', '101051', '101041'
        ];

        $seccionrios = Seccionrio::whereNotIn('id', $excludedSeccionrioIds)
                                ->get();
        return response()->json($seccionrios);
    }
}
