<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class RegionController extends Controller
{
    // Método para obtener el GeoJSON de los límites de la región de Coquimbo
    public function getRegionCoquimboGeojson()
    {
        $path = public_path('assets/Region_Coquimbo.geojson');  // Ruta del archivo GeoJSON

        if (!File::exists($path)) {
            return response()->json(['error' => 'Archivo no encontrado'], 404);  // Retorna error si no existe
        }

        $geojson = File::get($path);  // Obtiene el contenido del archivo

        return response($geojson, 200)->header('Content-Type', 'application/json');  // Retorna el archivo con el header adecuado
    }

    // Método para obtener el GeoJSON de los límites de las provincias
    public function getProvincesGeojson()
    {
        $path = public_path('assets/provincias.geojson');  // Ruta del archivo GeoJSON de provincias

        if (!File::exists($path)) {
            return response()->json(['error' => 'Archivo no encontrado'], 404);  // Retorna error si no existe
        }

        $geojson = File::get($path);  // Obtiene el contenido del archivo

        return response($geojson, 200)->header('Content-Type', 'application/json');  // Retorna el archivo con el header adecuado
    }

    // Método para obtener el GeoJSON de los límites de las comunas
    public function getComunasGeojson()
    {
        $path = public_path('assets/comunas.geojson');  // Ruta del archivo GeoJSON de comunas

        if (!File::exists($path)) {
            return response()->json(['error' => 'Archivo no encontrado'], 404);  // Retorna error si no existe
        }

        $geojson = File::get($path);  // Obtiene el contenido del archivo

        return response($geojson, 200)->header('Content-Type', 'application/json');  // Retorna el archivo con el header adecuado
    }
}
