<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Canal extends Model
{
    use HasFactory;

    protected $fillable = [
        'nombre',
        'fuentehidrica',
        'daatotales',
        'ltssegaccion',
        'daaequivalentes',
        'regulacion',
        'sectorhidrico_id',
        'seccionrio_id',
        'comuna_id',
        'subsubcuenca_id',
        'shac_id',
    ];

    public function comuna()
    {
        return $this->belongsTo(Comuna::class);
    }

    public function sectorhidrico()
    {
        return $this->belongsTo(Sectorhidrico::class);
    }

    public function seccionrio()
    {
        return $this->belongsTo(Seccionrio::class);
    }

    public function subsubcuenca()
    {
        return $this->belongsTo(Subsubcuenca::class);
    }

    public function shac()
    {
        return $this->belongsTo(Shac::class);
    }

    public function ofertasElqui()
    {
        return $this->hasMany(OfertaElqui::class, 'canal_id');
    }

    public function seccioncanals()
    {
        return $this->hasMany(Seccioncanal::class, 'canal_id');
    }

    public function demandasHidricas()
    {
        return $this->hasMany(DhElqui::class, 'canal_id', 'id');
    }

    public function perdidasConduccion()
    {
        return $this->hasMany(PerdidasConduccion::class, 'canal_id', 'id');
    }

}
