<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class DemandaHidricaM3 extends Model
{
    protected $table = 'demanda_hidrica_consolidada_anual_canales_limari'; // por defecto

    protected $fillable = [
        'id',
        'nombre',
        'anho',
        'demanda_hidrica_bruta_m3',
        'mes',
    ];

    public static function setTableForProvince($provincia)
    {
        switch ($provincia) {
            case '43': // limari
                return 'demanda_hidrica_consolidada_anual_canales_limari';
            case '42': // choapa
                return 'demanda_hidrica_consolidada_anual_canales_choapa';
            case '41': // elqui
                return 'demanda_hidrica_consolidada_anual_canales_elqui';
            default:
                return 'demanda_hidrica_consolidada_anual_canales_limari';
        }
    }

    // Función para obtener la demanda hídrica combinada de las tres provincias
    public static function getCombinedDemandaHidrica()
    {
        // Consultar los datos de cada tabla
        $limari = DB::table('demanda_hidrica_consolidada_anual_canales_limari')
            ->select('id', 'nombre', 'anho', 'demanda_hidrica_bruta_m3', 'mes')
            ->get();

        $choapa = DB::table('demanda_hidrica_consolidada_anual_canales_choapa')
            ->select('id', 'nombre', 'anho', 'demanda_hidrica_bruta_m3', 'mes')
            ->get();

        $elqui = DB::table('demanda_hidrica_consolidada_anual_canales_elqui')
            ->select('id', 'nombre', 'anho', 'demanda_hidrica_bruta_m3', 'mes')
            ->get();

        // Combinar los resultados
        return $limari->merge($choapa)->merge($elqui);
    }

    public static function getCombinedDemandaHidricaMonthYear($cuenca)
    {
        switch ($cuenca) {
            case '44' & '45' & '46': // limari
                return 'demanda_hidrica_consolidada_anual_canales_limari';
            case '47' & '48' & '49': // choapa
                return 'demanda_hidrica_consolidada_anual_canales_choapa';
            case '40' & '41' & '42' & '43': // elqui
                return 'demanda_hidrica_consolidada_anual_canales_elqui';
            default:
                return 'demanda_hidrica_consolidada_anual_canales_limari';
        }
    }

    public static function getCombinedDemandaHidricaMonthYearOrganization($organizacion)
    {
        switch ($organizacion) {
            case '201' & '202' & '203' & '204' & '205' & '206' & '207' & '211' & '212' & '213' & '214' & '215': // limari
                return 'demanda_hidrica_consolidada_anual_canales_limari';
            case '301' & '302' & '303': // choapa
                return 'demanda_hidrica_consolidada_anual_canales_choapa';
            case '101' & '102': // elqui
                return 'demanda_hidrica_consolidada_anual_canales_elqui';
            default:
                return 'demanda_hidrica_consolidada_anual_canales_limari';
        }
    }
}
