<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DfChoapa extends Model
{
    use HasFactory;

    // Define la tabla que representa este modelo
    protected $table = 'df_choapa';
    public $timestamps = false;

    // Campos que se pueden llenar masivamente
    protected $fillable = [
        'canal_id',
        'Canal',
        'Temporada',
        'Demanda_mm_ha',
        'Oferta_mm',
        'DF',
        'Excedencia_Weibull',
        'Clasificación',
        'Periodo'
    ];

    // Relación con el modelo Canal
    public function canal()
    {
        return $this->belongsTo(Canal::class);
    }

    // Mutators para convertir comas en puntos antes de guardar los valores
    public function setDemandaMmHaAttribute($value)
    {
        $this->attributes['Demanda_mm_ha'] = str_replace(',', '.', $value);
    }

    public function setOfertaMmAttribute($value)
    {
        $this->attributes['Oferta_mm'] = str_replace(',', '.', $value);
    }

    public function setDFAttribute($value)
    {
        $this->attributes['DF'] = str_replace(',', '.', $value);
    }

    public function setExcedenciaWeibullAttribute($value)
    {
        $this->attributes['Excedencia_Weibull'] = str_replace(',', '.', $value);
    }
}
