<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DfChoapaMpiLr extends Model
{
    use HasFactory;

    protected $table = 'df_choapa_mpi_lr'; // Nombre de la tabla
    public $timestamps = false; // No utiliza timestamps

    // Columnas rellenables
    protected $fillable = [
        'Canal',
        'canal_id',
        'Temporada',
        'Demanda_mm_ha',
        'Oferta_mm',
        'DF',
        'Excedencia_Weibull',
        'Clasificación',
        'Periodo'
    ];

    // Relación con la tabla 'canals'
    public function canal()
    {
        return $this->belongsTo(Canal::class);
    }

    // Mutadores para asegurar el formato de los valores flotantes
    public function setDemandaMmHaAttribute($value)
    {
        $this->attributes['Demanda_mm_ha'] = str_replace(',', '.', $value);
    }

    public function setOfertaMmAttribute($value)
    {
        $this->attributes['Oferta_mm'] = str_replace(',', '.', $value);
    }

    public function setDFAttribute($value)
    {
        $this->attributes['DF'] = str_replace(',', '.', $value);
    }

    public function setExcedenciaWeibullAttribute($value)
    {
        $this->attributes['Excedencia_Weibull'] = str_replace(',', '.', $value);
    }
}
