<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DfElquiMpiLr extends Model
{
    use HasFactory;

    protected $table = 'df_elqui_mpi_lr';
    public $timestamps = false;

    protected $fillable = [
        'canal_id',
        'Canal',
        'Temporada',
        'Demanda_mm_ha',
        'Oferta_mm',
        'DF',
        'Excedencia_Weibull',
        'Clasificación',
        'Periodo'
    ];

    public function canal()
    {
        return $this->belongsTo(Canal::class);
    }

    public function setDemandaMmHaAttribute($value)
    {
        $this->attributes['Demanda_mm_ha'] = str_replace(',', '.', $value);
    }

    public function setOfertaMmAttribute($value)
    {
        $this->attributes['Oferta_mm'] = str_replace(',', '.', $value);
    }

    public function setDFAttribute($value)
    {
        $this->attributes['DF'] = str_replace(',', '.', $value);
    }

    public function setExcedenciaWeibullAttribute($value)
    {
        $this->attributes['Excedencia_Weibull'] = str_replace(',', '.', $value);
    }
}
