<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class DfLimariMpiLr extends Model
{
    use HasFactory;

    protected $table = 'df_limari_mpi_lr'; // Nombre de la tabla
    public $timestamps = false; // No utiliza timestamps

    // Columnas rellenables
    protected $fillable = [
        'Canal',
        'canal_id',
        'Temporada',
        'Demanda_mm_ha',
        'Oferta_mm',
        'DF',
        'Excedencia_Weibull',
        'Clasificación',
        'Periodo'
    ];

    // Relación con la tabla 'canals'
    public function canal()
    {
        return $this->belongsTo(Canal::class);
    }

    // Mutadores para asegurar el formato de los valores flotantes
    public function setDemandaMmHaAttribute($value)
    {
        $this->attributes['Demanda_mm_ha'] = str_replace(',', '.', $value);
    }

    public function setOfertaMmAttribute($value)
    {
        $this->attributes['Oferta_mm'] = str_replace(',', '.', $value);
    }

    public function setDFAttribute($value)
    {
        $this->attributes['DF'] = str_replace(',', '.', $value);
    }

    public function setExcedenciaWeibullAttribute($value)
    {
        $this->attributes['Excedencia_Weibull'] = str_replace(',', '.', $value);
    }

    protected function getDataFromModel($modelClass, $canalId, $periodo = null)
{
    // Crear la consulta base
    $query = $modelClass::where('canal_id', $canalId);

    // Agregar filtro de Periodo si está presente
    if (!empty($periodo)) {
        $query->where('Periodo', $periodo);
    }

    // Log para depurar la consulta
    Log::info('Consulta ejecutada', ['query' => $query->toSql(), 'bindings' => $query->getBindings()]);

    return $query->get();
}


}
