<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndicadorPrommraIPSL extends Model
{
    use HasFactory;


    protected $table = 'indicador_prommra_ipsl';


    protected $primaryKey = 'id';


    public $incrementing = true;


    protected $keyType = 'int';


    public $timestamps = false;


    protected $fillable = [
        'canal',
        'periodo',
        'probabilidad_excedencia',
        'indicador_prommra',
        'clasificacion',
        'canal_id',
    ];


    public function setProbabilidadExcedenciaAttribute($value)
    {
        $this->attributes['probabilidad_excedencia'] = str_replace(',', '.', $value);
    }

    public function setIndicadorPrommraAttribute($value)
    {
        $this->attributes['indicador_prommra'] = str_replace(',', '.', $value);
    }


    public function canal()
    {
        return $this->belongsTo(Canal::class, 'canal_id', 'id');
    }


}
