<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfertaChoapaIpsl extends Model
{
    use HasFactory;

    protected $table = 'oferta_choapa_ipsl';

    protected $primaryKey = 'id';

    protected $fillable = [
        'organizacion_id',
        'canal_id',
        'fecha',
        'ofertahidrica',
    ];

    public $timestamps = false;

    public function organizacion()
    {
        return $this->belongsTo(Organizacion::class, 'organizacion_id');
    }

    public function canal()
    {
        return $this->belongsTo(Canal::class, 'canal_id');
    }
}
