<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfertaLimari extends Model
{
    use HasFactory;

    // Nombre de la tabla
    protected $table = 'oferta_limari';

    // Clave primaria
    protected $primaryKey = 'id';

    // Campos que pueden ser asignados masivamente
    protected $fillable = [
        'organizacion_id',
        'canal_id',
        'fecha',
        'ofertahidrica',
    ];

    // Deshabilitar timestamps si no existen en la tabla
    public $timestamps = false;

    // Relaciones con otros modelos
    public function organizacion()
    {
        return $this->belongsTo(Organizacion::class, 'organizacion_id');
    }

    public function canal()
    {
        return $this->belongsTo(Canal::class, 'canal_id');
    }
}
