<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfertaLimariMpiLr extends Model
{
    use HasFactory;

    protected $table = 'oferta_limari_mpi_lr';  // Nombre de la tabla en la base de datos

    protected $primaryKey = 'id';  // Llave primaria de la tabla

    protected $fillable = [
        'organizacion_id',  // Campo para la organización
        'canal_id',         // Campo para el canal
        'fecha',            // Fecha del registro
        'ofertahidrica',    // Dotación de oferta hídrica
    ];

    public $timestamps = false;  // Desactivar timestamps (created_at, updated_at)

    // Relación con la tabla organizaciones
    public function organizacion()
    {
        return $this->belongsTo(Organizacion::class, 'organizacion_id');
    }

    // Relación con la tabla canales
    public function canal()
    {
        return $this->belongsTo(Canal::class, 'canal_id');
    }
}
