<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfertaSeccRioLimariMpiLr extends Model
{
    use HasFactory;

    // Nombre de la tabla en la base de datos
    protected $table = 'oferta_secc_rio_limari_mpi_lr';

    // Campos que se pueden asignar en masa
    protected $fillable = [
        'seccionrio_id',
        'fecha',
        'mes',
        'ofertahidrica'
    ];

    /**
     * Relación con la tabla 'seccionrios'.
     * Un registro de oferta pertenece a una sección de río.
     */
    public function seccionrio()
    {
        return $this->belongsTo(Seccionrio::class, 'seccionrio_id', 'id');
    }
}
