<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PerdidasConduccion extends Model
{
    use HasFactory;

    // Especificar la tabla asociada
    protected $table = 'perdidasconduccion';

    // Definir los campos que son asignables en masa
    protected $fillable = [
        'canal_id',
        'perdida'
    ];

    // Relación con la tabla 'canales'
    public function canal()
    {
        return $this->belongsTo(Canal::class, 'canal_id', 'id');
    }
}
