<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuperficieActiva extends Model
{
    protected $table = 'superficie_activa_limari_por_temporada'; // por defecto

    protected $fillable = [
        'id',
        'canal_v2',
        'area_ha',
        'temporada',
    ];

    public static function setTableForProvince($provincia)
    {
        switch ($provincia) {
            // elqui
            case '41':
                return 'superficie_activa_elqui_por_temporada';
            // choapa
            case '42':
                return 'superficie_activa_choapa_por_temporada';
            // limari
            case '43':
                return 'superficie_activa_limari_por_temporada';
            default:
                return 'superficie_activa_limari_por_temporada';
        }
    }
}
