<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\VerifyEmail as BaseVerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;

class CustomVerifyEmail extends BaseVerifyEmail
{
    public function toMail($notifiable)
    {
        $verificationUrl = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject('Confirma tu dirección de correo electrónico')
            ->greeting('¡Hola!')
            ->line('Gracias por registrarte en nuestra plataforma. Por favor, confirma tu dirección de correo electrónico haciendo clic en el botón a continuación.')
            ->action('Confirmar Correo Electrónico', $verificationUrl)
            ->line('Si no creaste esta cuenta, no necesitas realizar ninguna acción.')
            ->salutation('Saludos, Equipo PROMMRA');
    }

    /**
     * Genera la URL de verificación firmada.
     *
     * @param $notifiable
     * @return string
     */
    protected function verificationUrl($notifiable)
{
    return URL::temporarySignedRoute(
        'verification.verify', // Nombre de la ruta
        Carbon::now()->addMinutes(60), // Duración del enlace (60 minutos)
        [
            'id' => $notifiable->getKey(),
            'hash' => sha1($notifiable->getEmailForVerification()),
        ]
    );
}


}
