<?php

namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Auth\Notifications\ResetPassword as BaseResetPassword;

class ResetPasswordCustom extends BaseResetPassword
{
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Restablece tu contraseña')
            ->greeting('¡Hola!')
            ->line('Estás recibiendo este correo porque solicitaste restablecer tu contraseña.')
            ->action('Restablecer Contraseña', url(config('app.url') . route('password.reset', $this->token, false)))
            ->line('Si no solicitaste este cambio, no es necesario realizar ninguna acción.')
            ->salutation('Saludos, Equipo PROMMRA');
    }
}
