<?php

return [

    'defaults' => [
        'guard' => 'api', // Cambia el guard por defecto a 'api' si usas JWT para APIs.
        'passwords' => 'users',
    ],

    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        'api' => [
            'driver' => 'jwt', // Asegúrate de tener JWT correctamente configurado.
            'provider' => 'users',
        ],
    ],

    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],
    ],

    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table' => 'password_resets',
            'expire' => 60, // Tiempo en minutos antes de que expire un enlace de restablecimiento.
            'throttle' => 60, // Tiempo en minutos antes de permitir otro intento de restablecimiento.
        ],
    ],

    'verification' => [
        'expire' => 1440, // Tiempo en minutos antes de que expire un enlace de verificación (24 horas).
    ],

    'password_timeout' => 10800, // Tiempo de sesión para acciones de contraseña sensible.
];
