<?php

return [

    /*
    |--------------------------------------------------------------------------
    | JWT Secret
    |--------------------------------------------------------------------------
    |
    | This value is the secret key used to sign your JWT tokens. You should
    | set this in your .env file. Use the command `php artisan jwt:secret`
    | to generate a new key. This will update your .env file automatically.
    |
    */

    'secret' => env('JWT_SECRET'),

    /*
    |--------------------------------------------------------------------------
    | JWT Keys
    |--------------------------------------------------------------------------
    |
    | The public and private keys for RSA or ECDSA algorithms. If you are
    | using the HS256 algorithm, you don't need to set these keys. If you
    | are using RSA or ECDSA, you need to generate these keys.
    |
    */

    'keys' => [
        'public' => env('JWT_PUBLIC_KEY'),
        'private' => env('JWT_PRIVATE_KEY'),
    ],

    /*
    |--------------------------------------------------------------------------
    | JWT Time to Live
    |--------------------------------------------------------------------------
    |
    | Specify the length of time (in minutes) that the token will be valid
    | for. Defaults to 1 hour. You can change this to any value that you
    | need for your application.
    |
    */

    'ttl' => env('JWT_TTL', 60),

    /*
    |--------------------------------------------------------------------------
    | Refresh Time to Live
    |--------------------------------------------------------------------------
    |
    | Specify the length of time (in minutes) that the refresh token will be
    | valid for. Defaults to 2 weeks. You can change this to any value that
    | you need for your application.
    |
    */

    'refresh_ttl' => env('JWT_REFRESH_TTL', 20160),

    /*
    |--------------------------------------------------------------------------
    | JWT Algorithm
    |--------------------------------------------------------------------------
    |
    | Specify the algorithm that will be used to sign the tokens. The
    | default value is HS256. You can change this to any supported
    | algorithm that you need for your application.
    |
    */

    'algo' => env('JWT_ALGO', 'HS256'),

    /*
    |--------------------------------------------------------------------------
    | Required Claims
    |--------------------------------------------------------------------------
    |
    | Specify the claims that must exist in any token. A TokenInvalidException
    | will be thrown if any of these claims are not present in the payload.
    |
    */

    'required_claims' => [
        'iss',
        'iat',
        'exp',
        'nbf',
        'sub',
        'jti',
    ],

    /*
    |--------------------------------------------------------------------------
    | Persistent Claims
    |--------------------------------------------------------------------------
    |
    | Specify the claims that should persist when refreshing a token. These
    | claims will be added to the new token.
    |
    */

    'persistent_claims' => [],

    /*
    |--------------------------------------------------------------------------
    | Blacklist Enabled
    |--------------------------------------------------------------------------
    |
    | Specify if the tokens should be blacklisted. This is useful if you
    | need to invalidate tokens after they have been issued.
    |
    */

    'blacklist_enabled' => env('JWT_BLACKLIST_ENABLED', true),

    /*
    |--------------------------------------------------------------------------
    | Blacklist Grace Period
    |--------------------------------------------------------------------------
    |
    | Specify the grace period (in seconds) that the blacklist will tolerate
    | before the token is blacklisted. This is useful if you have a delay in
    | the request and need to prevent tokens from being blacklisted.
    |
    */

    'blacklist_grace_period' => env('JWT_BLACKLIST_GRACE_PERIOD', 0),

    /*
    |--------------------------------------------------------------------------
    | Providers
    |--------------------------------------------------------------------------
    |
    | Specify the providers that will be used to encode and decode the tokens.
    | You can change these to any custom implementation that you need for
    | your application.
    |
    */

    'providers' => [
        'jwt' => Tymon\JWTAuth\Providers\JWT\Lcobucci::class,
        'auth' => Tymon\JWTAuth\Providers\Auth\Illuminate::class,
        'storage' => Tymon\JWTAuth\Providers\Storage\Illuminate::class,
    ],
];
