<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIrrisatapisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('irrisatapis', function (Blueprint $table) {
            $table->id();
            $table->integer('anho');
            $table->integer('mes');
            /* $table->double('kc',8,2); */
            $table->unsignedBigInteger('sectorhidrico_id');
            $table->foreign('sectorhidrico_id')->references('id')->on('sectorhidricos')->onDelete('cascade');
            $table->unsignedBigInteger('grupo_id');
            $table->foreign('grupo_id')->references('id')->on('grupos')->onDelete('cascade');
            $table->unsignedBigInteger('kc_id');
            $table->foreign('kc_id')->references('id')->on('kcs')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('irrisatapis');
    }
}
