<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCanalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('canals', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('fuentehidrica')->nullable();
            $table->string('daatotales')->nullable();
            $table->string('ltssegaccion')->nullable();
            $table->string('daaequivalentes')->nullable();
            $table->string('regulacion')->nullable();
            $table->unsignedBigInteger('sectorhidrico_id');
            $table->foreign('sectorhidrico_id')->references('id')->on('sectorhidricos')->onDelete('cascade');
            /* $table->unsignedBigInteger('organizacion_id');
            $table->foreign('organizacion_id')->references('id')->on('organizacions')->onDelete('cascade'); */
            $table->unsignedBigInteger('seccionrio_id');
            $table->foreign('seccionrio_id')->references('id')->on('seccionrios')->onDelete('cascade');
            $table->unsignedBigInteger('comuna_id');
            $table->foreign('comuna_id')->references('id')->on('comunas')->onDelete('cascade');
            $table->unsignedBigInteger('subsubcuenca_id');
            $table->foreign('subsubcuenca_id')->references('id')->on('subsubcuencas')->onDelete('cascade');
            $table->unsignedBigInteger('shac_id');
            $table->foreign('shac_id')->references('id')->on('shacs')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('canals');
    }
}
