<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrazadocanalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trazadocanals', function (Blueprint $table) {
            $table->id();
            $table->string('longitud');
            $table->string('revestimiento');
            $table->string('porcentajeperdida');
            $table->unsignedBigInteger('canal_id');
            $table->foreign('canal_id')->references('id')->on('canals')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trazadocanals');
    }
}
