<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePoligonosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('poligonos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seccioncanal_id');
            $table->foreign('seccioncanal_id')->references('id')->on('seccioncanals')->onDelete('cascade');
            $table->string('superficie');
            $table->string('geo')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('poligonos');
    }
}
