<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTableOfertahidrica extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ofertahidricas', function (Blueprint $table) {
            $table->unsignedBigInteger('organizacion_id')->nullable();
            $table->foreign('organizacion_id','oferta_organizacion_foreign')->references('id')->on('organizacions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ofertahidricas', function (Blueprint $table) {
            $table->dropForeign('oferta_organizacion_foreign');
            $table->dropColumn('organizacion_id');
        });
    }
}
