<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEtofactorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('etofactors', function (Blueprint $table) {
            $table->id();
            $table->integer('mes');
            $table->float('factor');
            $table->unsignedBigInteger('sectorhidrico_id');
            $table->foreign('sectorhidrico_id')->references('id')->on('sectorhidricos')->onDelete('cascade');
            $table->unsignedBigInteger('emaceaza_id');
            $table->foreign('emaceaza_id')->references('id')->on('emaceazas')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('etofactors');
    }
}
