<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDemandaHidricasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('demanda_hidrica', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('canal');
            $table->string('temporada');
            $table->decimal('demanda', 15, 2);
            $table->string('periodo');
            $table->timestamps();

            // Clave foránea
            $table->foreign('canal')->references('id')->on('canals')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('demanda_hidrica');
    }
}
