<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCanalIdToDfElquiTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('df_elqui', function (Blueprint $table) {
            $table->unsignedBigInteger('canal_id')->nullable()->after('Canal');

            // Si la tabla 'canals' tiene una columna 'id' que es clave primaria
            $table->foreign('canal_id')->references('id')->on('canals')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('df_elqui', function (Blueprint $table) {
            $table->dropForeign(['canal_id']);
            $table->dropColumn('canal_id');
        });
    }
}
