@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="form-group">
                <label for="searchCanal">Buscar Canal Hídrico</label>
                <input type="text" class="form-control" id="searchCanal" placeholder="Buscar por nombre de canal">
            </div>

            <div class="card">
                <div class="card-header">
                    Consultar Canal Hídrico
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4>Por Provincia - Comuna - Canal</h4>
                            <div class="form-group">
                                <label for="selectProvincia">Provincia</label>
                                <select id="selectProvincia" class="form-select">
                                    <option value="">Seleccionar Provincia</option>
                                    @foreach($provincias as $provincia)
                                        <option value="{{ $provincia->id }}">{{ $provincia->nombre }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="selectComuna">Comuna</label>
                                <select id="selectComuna" class="form-select">
                                    <option value="">Seleccionar Comuna</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="selectCanal">Canal Hídrico</label>
                                <select id="selectCanal" class="form-select">
                                    <option value="">Seleccionar Canal</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h4>Por Organización - Sección Río - Canal</h4>
                            <!-- Aquí irán los botones desplegables para la otra forma de búsqueda -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        // Evento change para el campo de provincia
        $('#selectProvincia').change(function() {
            var provincia_id = $(this).val();
            if (provincia_id) {
                // Envía una solicitud AJAX al servidor para obtener las comunas correspondientes
                $.ajax({
                    url: '/obtener-comunas/' + provincia_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        // Limpia el campo de comuna y agrega las nuevas opciones
                        $('#selectComuna').empty().append('<option value="">Seleccionar Comuna</option>');
                        $.each(data, function(key, value) {
                            $('#selectComuna').append('<option value="' + key + '">' + value + '</option>');
                        });
                    }
                });
            } else {
                // Si no se selecciona ninguna provincia, limpia el campo de comuna y canal
                $('#selectComuna').empty().append('<option value="">Seleccionar Comuna</option>');
                $('#selectCanal').empty().append('<option value="">Seleccionar Canal</option>');
            }
        });

        // Evento change para el campo de comuna
        $('#selectComuna').change(function() {
            var provincia_id = $('#selectProvincia').val();
            var comuna_id = $(this).val();
            if (comuna_id) {
                // Envía una solicitud AJAX al servidor para obtener los canales correspondientes
                $.ajax({
                    url: '/obtener-canales/' + provincia_id + '/' + comuna_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        // Limpia el campo de canal y agrega las nuevas opciones
                        $('#selectCanal').empty().append('<option value="">Seleccionar Canal</option>');
                        $.each(data, function(key, value) {
                            $('#selectCanal').append('<option value="' + key + '">' + value + '</option>');
                        });
                    }
                });
            } else {
                // Si no se selecciona ninguna comuna, limpia el campo de canal
                $('#selectCanal').empty().append('<option value="">Seleccionar Canal</option>');
            }
        });
    });
</script>

@endsection
