@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="form-group">
                <label for="">Sectores hídricos</label>
                {!! Form::select('sectorhidrico_id', $sectoreshidricos, $sectorhidrico->id, ['class' => 'form-select','style' => 'width:200px;margin-bottom:20px;']) !!}
            </div>
            <div class="card">
                <div class="card-header">
                    Eto mensual - API CEAZAMET - {{$sectorhidrico->nombre}} 
                </div>

                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Sector hídrico</th>
                                <th>Fecha</th>
                                <th>Eto mensual</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($eto as $e)
                                <tr>
                                    <td>{{$e->sectorhidrico_id}}</td>
                                    <td>{{$e->mes}}/{{$e->anho}}</td>
                                    <td>{{$e->eto}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("select[name=sectorhidrico_id]").change(function(){
            location.href = '/ceazamet/mensual?sectorhidrico_id='+$(this).val();
        })
    });
</script>
@endsection
