@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="form-group">
                <label for="">Estaciones ceaza</label>
                {!! Form::select('estacion_id', $estaciones, $estacion->id, ['class' => 'form-select','style' => 'width:200px;margin-bottom:20px;']) !!}
            </div>
            <div class="card">
                <div class="card-header">
                    Precipitación diaria - API CEAZAMET - {{$estacion->nombre}} (Codigo: {{$estacion->codeceaza}})
                </div>

                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Precipitación diaria</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($pps as $pp)
                                <tr>
                                    <td>{{$pp->date}}</td>
                                    <td>{{$pp->pp}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("select[name=estacion_id]").change(function(){
            location.href = '/ceazamet/ppdiario?emaceaza_id='+$(this).val();
        })
    });
</script>
@endsection
