@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="form-group">
                <label for="">Sectores hídricos</label>
                {!! Form::select('sectorhidrico_id', $sectoreshidricos, $selectedSectorId, ['class' => 'form-select', 'style' => 'width:200px; margin-bottom:20px;', 'id' => 'sectorhidrico-select']) !!}
            </div>
            <div class="card">
                <div class="card-header">
                    Precipitación mensual - API CEAZAMET
                </div>  

                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Sector hídrico</th>
                                <th>Fecha</th>
                                <th>Precipitación mensual</th>
                            </tr>
                        </thead>
                        <tbody id="precipitacion-mensual-body">
                            @if(isset($sectorData) && count($sectorData) > 0)
                            @foreach ($sectorData as $data)
                                <tr>
                                    <td>{{ $data->sectorhidrico_id }}</td>
                                    <td>{{ $data->mes }}/{{ $data->anho }}</td>
                                    <td>{{ $data->pp }}</td>
                        </tr>
                            @endforeach
                            @else
                                <tr>
                                    <td colspan="3">No se encontraron datos</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
    $("#sectorhidrico-select").change(function() {
        var sectorhidricoId = $(this).val();
        // Redirigir a la URL con sectorhidrico_id como parámetro
        window.location.href = '/ceazamet/ppmensual?sectorhidrico_id=' + sectorhidricoId;
    });
});
</script>
@endsection
