<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Support\Facades\Redirect;
use App\Http\Controllers\CeazametController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\GeojsonController;
use App\Http\Controllers\HydricBalanceController;
use App\Http\Controllers\HydricDemandController;
use App\Http\Controllers\OrphanopoulusIndicatorController;
use App\Http\Controllers\OrphanopoulusIndicatorIpslController;
use App\Http\Controllers\OrphanopoulusIndicatorMpiLrController;
use App\Http\Controllers\DfElquiController;
use App\Http\Controllers\DfElquiIpslController;
use App\Http\Controllers\DfElquiMpiLrController;
use App\Http\Controllers\IndicadorPrommraController;
use App\Http\Controllers\IndicadorPrommraIpslController;
use App\Http\Controllers\IndicadorPrommraMpiLrController;
use App\Http\Controllers\HydricDemandCcsmController;
use App\Http\Controllers\HydricDemandMpiLrController;
use App\Http\Controllers\HydricDemandIpslController;
use App\Http\Controllers\CalculoCanalCsiroController;
use App\Http\Controllers\CalculoCanalIpslController;
use App\Http\Controllers\CalculoCanalMpiLrController;
use App\Http\Controllers\CalculoCanalDFController;
use App\Http\Controllers\IndicadorOrphanopoulusController;
use App\Http\Controllers\DemandaHidricaM3Controller;
use App\Http\Controllers\SuperficieActivaController;
use App\Http\Controllers\RegionController;
use App\Http\Controllers\CanalController;
use Illuminate\Support\Facades\Log;

Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [RegisterController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth:api');
Route::get('/email/verify/{id}/{hash}', function ($id, $hash) {
    $user = \App\Models\User::find($id);

    if (!$user) {
        return Redirect::to('http://localhost:5173/email-verification?status=user-not-found');
    }

    if (!hash_equals(sha1($user->getEmailForVerification()), $hash)) {
        return Redirect::to('http://localhost:5173/email-verification?status=invalid-link');
    }

    if ($user->hasVerifiedEmail()) {
        return Redirect::to('http://localhost:5173/email-verification?status=already-verified');
    }

    $user->markEmailAsVerified();

    return Redirect::to('http://localhost:5173/email-verification?status=success');
})->middleware('signed')->name('verification.verify');

Route::post('/email/resend', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return response()->json(['message' => 'Correo de verificación reenviado'], 200);
})->middleware(['auth:api', 'throttle:6,1'])->name('verification.resend');
Route::post('/password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::post('/password/reset', [ResetPasswordController::class, 'reset'])->name('password.reset');
Route::get('/geojson', [GeojsonController::class, 'getGeojson']);
Route::get('/region-coquimbo-geojson', [RegionController::class, 'getRegionCoquimboGeojson']);
Route::get('/provinces-geojson', [RegionController::class, 'getProvincesGeojson']);
Route::get('/comunas-geojson', [RegionController::class, 'getComunasGeojson']);
Route::get('/hydric-balance', [HydricBalanceController::class, 'getHydricBalance']);
Route::get('/hydric-demand-rws', [HydricDemandController::class, 'getHydricDemandRWS']);
Route::get('/hydric-demand-rws-ccsm', [HydricDemandCcsmController::class, 'getHydricDemandRWS']);
Route::get('/hydric-demand-rws-mpi-lr', [HydricDemandMpiLrController::class, 'getHydricDemandRWS']);
Route::get('/hydric-demand-rws-ipsl', [HydricDemandIpslController::class, 'getHydricDemandRWS']);
Route::get('/calculate-orphanopoulus-indicator', [OrphanopoulusIndicatorController::class, 'calculateOrphanopoulusIndicator']);
Route::get('/calculate-orphanopoulus-indicator-ipsl', [OrphanopoulusIndicatorIpslController::class, 'calculateOrphanopoulusIndicator']);
Route::get('/calculate-orphanopoulus-indicator-mpi-lr', [OrphanopoulusIndicatorMpiLrController::class, 'calculateOrphanopoulusIndicator']);
Route::get('/df_elqui', [DfElquiController::class, 'index']);
Route::get('/df_elqui_ipsl', [DfElquiIpslController::class, 'index']);
Route::get('/df_elqui_mpi_lr', [DfElquiMpiLrController::class, 'index']);
Route::get('/indicador_prommra', [IndicadorPrommraController::class, 'index']);
Route::get('/indicador_prommra_ipsl', [IndicadorPrommraIpslController::class, 'index']);
Route::get('/indicador_prommra_mpi_lr', [IndicadorPrommraMpiLrController::class, 'index']);
Route::get('/calcular-oferta/{canal_id}/{periodo}/{superficie}/{grupo_id}/{sistema_riego}/{daa}', [CalculoCanalCsiroController::class, 'calcularOfertaPorCanal']);
Route::get('/calcular-oferta-ipsl/{canal_id}/{periodo}/{superficie}/{grupo_id}/{sistema_riego}/{daa}', [CalculoCanalIpslController::class, 'calcularOfertaPorCanal']);
Route::get('/calcular-oferta-mpi/{canal_id}/{periodo}/{superficie}/{grupo_id}/{sistema_riego}/{daa}', [CalculoCanalMpiLrController::class, 'calcularOfertaPorCanal']);
Route::get('/calcular-df/{canal_id}/{periodo}/{daa}', [CalculoCanalDFController::class, 'calcularDFPorCanal']);
Route::get('/indicador-orphanopoulus/{canal_id}/{periodo}/{superficie}/{grupo_id}/{sistema_riego}/{daa}', 
    [IndicadorOrphanopoulusController::class, 'calcularIndicadorOrphanopoulus']);
Route::get('/provincia-canal', [DemandaHidricaM3Controller::class, 'getProvinciaCanal']);
Route::get('/canal/{canalId}', [CanalController::class, 'obtenerDatosCanal']);

////// Demanda hidrica Modulo 3 /////
Route::get('/canales', [DemandaHidricaM3Controller::class, 'getCanal']);
Route::get('/provincia-canal', [DemandaHidricaM3Controller::class, 'getProvinciaCanal']);
////// Demanda hidrica Modulo 3 /////
//Route::get('/demanda-hidrica', [DemandaHidricaM3Controller::class, 'getDemanda']);
//Route::get('/demanda-hidrica-by-year', [DemandaHidricaM3Controller::class, 'getDemandaByYear']);
//Route::get('/demanda-hidrica-canal-by-year', [DemandaHidricaM3Controller::class, 'getDemandaByAnho']);
Route::get('/demanda-hidrica-canal', [DemandaHidricaM3Controller::class, 'getCanalDemanda']);
Route::get('/demanda-hidrica-canal-by-month', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnho']);
Route::get('/demanda-hidrica-canal-by-month-and-year', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensual']);
// Obtener la Demanda por Provincia
Route::get('/demanda-hidrica-provincia', [DemandaHidricaM3Controller::class, 'getProvinciaDemanda']);
Route::get('/demanda-hidrica-month-provincia', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoProvincia']);
Route::get('/demanda-hidrica-month-year-provincia', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualProvincia']);
// Obtener la Demanda por Comuna
Route::get('/demanda-hidrica-comuna', [DemandaHidricaM3Controller::class, 'getComunaDemanda']);
Route::get('/demanda-hidrica-month-comuna', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoComuna']);
Route::get('/demanda-hidrica-month-year-comuna', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualComuna']);
// Obtener la Demanda por Cuenca 
Route::get('/demanda-hidrica-cuenca', [DemandaHidricaM3Controller::class, 'getCuencaDemanda']);
Route::get('/demanda-hidrica-month-cuenca', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoCuenca']);
Route::get('/demanda-hidrica-month-year-cuenca', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualCuenca']);
// Obtener la Demanda por Subcuenca
Route::get('/demanda-hidrica-subcuenca', [DemandaHidricaM3Controller::class, 'getSubcuencaDemanda']);
Route::get('/demanda-hidrica-month-subcuenca', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoSubcuenca']);
Route::get('/demanda-hidrica-month-year-subcuenca', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualSubcuenca']);
// Obtener la Demanda por Organizacion
Route::get('/demanda-hidrica-organizacion', [DemandaHidricaM3Controller::class, 'getOrganizacionDemanda']);
Route::get('/demanda-hidrica-month-organizacion', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoOrganizacion']);
Route::get('/demanda-hidrica-month-year-organizacion', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualOrganizacion']);

// Obtener la Demanda por Rio
Route::get('/demanda-hidrica-rio', [DemandaHidricaM3Controller::class, 'getRioDemanda']);
Route::get('/demanda-hidrica-month-rio', [DemandaHidricaM3Controller::class, 'getDemandaMensualPorAnhoRio']);
Route::get('/demanda-hidrica-month-year-rio', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensualRio']);



// Superficie Modulo 3
Route::get('/superfice', [SuperficieActivaController::class, 'getSuperficie']);
Route::get('/superficie-by-year', [SuperficieActivaController::class, 'getCanalSuperficie']); // Obtiene el promedio, superficie maxima y minima
Route::get('/superficie-canal', [SuperficieActivaController::class, 'getSuperficieByYear']);
Route::get('/superficie-canal-by-year', [SuperficieActivaController::class, 'getSuperficieByTemporada']);
Route::get('/superficie-canal-by-temporada-and-cultivo', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivo']);
// Obtener la superficie por Provincia
Route::get('/superficie-provincia', [SuperficieActivaController::class, 'getProvinciaSuperficie']);
Route::get('/superficie-temporada-provincia', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoProvincia']);
// Obtener la superficie por Comuna
Route::get('/superficie-comuna', [SuperficieActivaController::class, 'getComunaSuperficie']);
Route::get('/superficie-temporada-comuna', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoComuna']);
// Obtener la superficie por Cuenca
Route::get('/superficie-cuenca', [SuperficieActivaController::class, 'getCuencaSuperficie']);
Route::get('/superficie-temporada-cuenca', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoCuenca']);
// Obtener la superficie por Subcuenca
Route::get('/superficie-subcuenca', [SuperficieActivaController::class, 'getSubcuencaSuperficie']);
Route::get('/superficie-temporada-subcuenca', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoSubcuenca']);
// Obtener la superficie por Organizacion
Route::get('/superficie-organizacion', [SuperficieActivaController::class, 'getSuperficiePorOrganizacion']);
Route::get('/superficie-temporada-organizacion', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoOrganizacion']);
// Obtener la superficie por Rio
Route::get('/superficie-rio', [SuperficieActivaController::class, 'getSuperficiePorRio']);
Route::get('/superficie-temporada-rio', [SuperficieActivaController::class, 'getSuperficiePorTemporadaYCultivoRio']);

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('auth:api')->get('/ceazamet/estacion', [CeazametController::class, 'estacion']);
Route::middleware('auth:api')->get('/ceazamet/diario', [CeazametController::class, 'diario']);
Route::middleware('auth:api')->get('/ceazamet/generatemensual', [CeazametController::class, 'generatemensual']);
Route::middleware('auth:api')->get('/ceazamet/mensual', [CeazametController::class, 'mensual']);
Route::middleware('auth:api')->get('/ceazamet/ppdiario', [CeazametController::class, 'ppdiario']);
Route::middleware('auth:api')->get('/ceazamet/ppmensual', [CeazametController::class, 'ppmensual'])->name('ceaza.ppmensual');
Route::middleware('auth:api')->get('/ceazamet/actualizacion-inicial', [CeazametController::class, 'actualizacionInicial'])->name('ceaza.actualizacioninicial');
Route::middleware('auth:api')->get('/ceazamet/consulta-canal', [CeazametController::class, 'consultaCanal'])->name('consulta.canal');
Route::middleware('auth:api')->get('/obtener-comunas/{provincia_id}', [CeazametController::class, 'obtenerComunas'])->name('obtener.comunas');
Route::middleware('auth:api')->get('/obtener-canales/{provincia_id}/{comuna_id}', [CeazametController::class, 'obtenerCanales'])->name('obtener.canales');
Route::middleware('auth:api')->get('/ceazamet/estaciones', [CeazametController::class, 'getEstaciones']);
Route::middleware('auth:api')->get('/provincias', [LocationController::class, 'getProvincias']);
Route::middleware('auth:api')->get('/comunas/{provinciaId}', [LocationController::class, 'getComunas']);
Route::middleware('auth:api')->get('/canales/{comunaId}', [LocationController::class, 'getCanales']);
Route::middleware('auth:api')->get('/search-canales', [LocationController::class, 'searchCanales']);
Route::middleware('auth:api')->get('/seccioncanal/{id}', [LocationController::class, 'getSeccionCanalById']);
Route::middleware('auth:api')->get('/search-seccion-canal', [LocationController::class, 'searchSeccionCanales']);
Route::middleware('auth:api')->get('/cuencas', [LocationController::class, 'getCuencas']);
Route::middleware('auth:api')->get('/subcuencas', [LocationController::class, 'getSubcuencas']);
Route::middleware('auth:api')->get('/organizaciones', [LocationController::class, 'getOrganizaciones']);
Route::middleware('auth:api')->get('/seccionrios', [LocationController::class, 'getSeccionrios']);
//Route::middleware('auth:api')->get('/demanda-hidrica-canal', [DemandaHidricaM3Controller::class, 'getCanalDemanda']);
//Route::middleware('auth:api')->get('/demanda-hidrica-canal-by-month-and-year', [DemandaHidricaM3Controller::class, 'getDemandaAnualYMensual']);